#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=Include\P!x Shot.ico
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_Res_Comment=Take and save your screenshot easily
#AutoIt3Wrapper_Res_Description=d3monCorp
#AutoIt3Wrapper_Res_Fileversion=1.0.3.8
#AutoIt3Wrapper_Res_LegalCopyright=d3mon Corporation. All rights Reserved.
#AutoIt3Wrapper_Run_After=ResHacker.exe -add %out%, %out%, cursor.cur, CURSOR, CUST_CUR_1, 0
#AutoIt3Wrapper_Run_After=upx.exe --best --nrv2e --crp-ms=999999 "%out%"
#AutoIt3Wrapper_Run_Obfuscator=y
#Obfuscator_Parameters=/striponly
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
_ReduceMemory(-1)

#Include 'Include\HotKey.au3'
#include 'Include\_Resources.au3'
#include <ScreenCapture.au3>
#include 'Include\GUICtrlSetOnHover_UDF.au3'
Opt('GuiOnEventMode',1)


#Region Cursor
$hNormal = _LoadImageFromSystem($OCR_NORMAL)
$hIBeam = _LoadImageFromSystem($OCR_IBEAM)
$hCursor = _ResourceGet(50, $RT_CURSOR)
$dwSize = @extended
#EndRegion
;

Local $f_pix, $iExit_Event = -1, $s_left, $s_top, $s_width, $s_height
Local $s_pix = @ScriptDir & '\Include\', $s_inc = @ScriptDir & '\Include'

#Region FileInstall
If Not FileExists($s_inc) Then DirCreate($s_inc)
FileInstall('Include\P!x Shot.bmp', $s_pix & 'P!x Shot.bmp', 1)
FileInstall('Include\win7.png', $s_pix & 'win7.png', 1)
FileInstall('Include\close-h.bmp', $s_pix & 'close-h.bmp', 1)
FileInstall('Include\close-n.bmp', $s_pix & 'close-n.bmp', 1)
FileInstall('Include\close-p.bmp', $s_pix & 'close-p.bmp', 1)
FileInstall('Include\min-h.bmp', $s_pix & 'min-h.bmp', 1)
FileInstall('Include\min-n.bmp', $s_pix & 'min-n.bmp', 1)
FileInstall('Include\min-p.bmp', $s_pix & 'min-p.bmp', 1)
FileInstall('Include\Capture.wav', $s_pix & 'Capture.wav', 1)
#EndRegion
;


#Region GUI
$GUI = GUICreate('P!x Shot <d3monCorp>', 316, 446, -1, -1, BitOR(0x80000000, 0x00080000, 0x00020000), 0x00080000)
GUISetOnEvent(-3, '_Exit')
GUISetOnEvent(-7, '_Move')

GUICtrlCreatePic($s_pix & 'P!x Shot.bmp', 0, 0, 316, 446, 128)

$p_mn = GUICtrlCreatePic($s_pix & 'min-n.bmp', 207, 34, 27, 18)
GUICtrlSetOnHover($p_mn, '_Hover', '_NoHover')
GUICtrlSetOnEvent($p_mn, '_Min')

$p_cl = GUICtrlCreatePic($s_pix & 'close-n.bmp', 262, 34, 46, 18)
GUICtrlSetOnHover($p_cl, '_Hover', '_NoHover')
GUICtrlSetOnEvent($p_cl, '_Exit')

GUICtrlCreateLabel("Screenshot's directory :", 15, 90, 130)
GUICtrlSetFont(-1, 9)

GUICtrlCreateButton('Browse...', 145, 87, 55, 20)
GUICtrlSetOnEvent(-1, '_PixDir')

$e_dir = GUICtrlCreateEdit("", 15, 110, 285, 17, 2048 + 128)
GUICtrlSetState($e_dir, 128)

GUICtrlCreateLabel("", 8, 135, 300, 1, 0x1000)

GUICtrlCreateLabel('Picture extension :', 15, 145, 100)
GUICtrlSetFont(-1, 9)

$c_ext = GUICtrlCreateCombo('None', 120, 142, 50, 17, 0x3)
GUICtrlSetData($c_ext, 'BMP|GIF|JPG|PNG|TIF', 'None')
GUICtrlSetState($c_ext, 128)

GUICtrlCreateLabel('JPG quality (opt) :', 185, 145)
$e_jq = GUICtrlCreateEdit('80', 275, 143, 25, 20, 0x2000)

GUICtrlCreateLabel("", 8, 170, 300, 1, 0x1000)

GUICtrlCreateLabel('Default Capture...', 24, 178, 98)
GUICtrlSetFont(-1, 9)

$r_fs = GUICtrlCreateRadio('Full screen', 25, 195)
$r_ti = GUICtrlCreateRadio('Without taskbar and desktop icons', 25, 215)
$r_nt = GUICtrlCreateRadio('Without taskbar only', 25, 235)
$r_ni = GUICtrlCreateRadio('Without desktop icons only', 25, 255)

GUICtrlCreateLabel("", 8, 290, 300, 1, 0x1000)

GUICtrlCreateLabel('Options...', 25, 295)
GUICtrlSetFont(-1, 9)

$c_sc = GUICtrlCreateCheckbox('Show cursor on screenshot', 25, 314)
$c_fs = GUICtrlCreateCheckbox('Show special window on screenshot', 25, 334)

GUICtrlCreateLabel("", 16, 360, 285, 2, 0x1000)

$c_rst = GUICtrlCreateCheckbox('Reset the number of screenshots', 25, 367)

$b_ok = GUICtrlCreateButton('Apply', 85, 405, 140, 22)
GUICtrlSetState($b_ok, 128)
GUICtrlSetOnEvent(-1, '_Apply')

_WinAPI_SetLayeredWindowAttributes($GUI, 0xFFF200)
#EndRegion
;

#Region GUI_2
$GUI_2 = GUICreate("", 1, 1, -1, -1, 0x80000000 + 0x00800000, 0x00000008, $GUI)
GUISetBkColor(0x3399FF, $GUI_2)
WinSetTrans($GUI_2, "", 85)
#EndRegion

#Region GUI_3
$GUI_3 = GUICreate("", 50, 50, -20, -25, -1, 0x00080000 + 0x00000008, $GUI)

;~ GUICtrlCreateLabel('P!x Shot', 0, (@DesktopHeight / 2) - (72 / 2), @DesktopWidth, 100, 1)
;~ GUICtrlSetFont(-1, 72)

;~ $l_pn = GUICtrlCreateLabel("", 0, @DesktopHeight - 100, @DesktopWidth, 50, 1)
;~ GUICtrlSetFont(-1, 36)

_GDIPlus_Startup( )
_SetBitMap($GUI_3, $s_pix & 'win7.png', 0, @DesktopWidth, @DesktopHeight)

$f_wgh = WinGetHandle('[active]')
GUISetState(@SW_SHOW, $GUI_3)

WinActivate($f_wgh)
#EndRegion
;



If $CmdLine[0] Then
	If StringInStr($CmdLine[1], '/config')  Then
		$r_dir = FileReadLine($s_pix & 'P!xShot.cfg', 1)
		If $r_dir <> "" Then
			GUICtrlSetState($e_dir, 64)
			GUICtrlSetData($e_dir, $r_dir)
		EndIf
		$r_ext = FileReadLine($s_pix & 'P!xShot.cfg', 5)
		If $r_ext <> "" Then
			GUICtrlSetState($c_ext, 64)
			GUICtrlSetData($c_ext, $r_ext)
		EndIf
		If $r_dir <> "" Then
			GUICtrlSetState($r_fs, 1)
			GUICtrlSetState($b_ok, 64)
		EndIf

		If FileReadLine($s_pix & 'P!xShot.cfg', 2) = 'True' Then GUICtrlSetState($c_sc, 1)
		If FileReadLine($s_pix & 'P!xShot.cfg', 4) = 'True' Then GUICtrlSetState($c_fs, 1)

		If FileReadLine($s_pix & 'P!xShot.cfg', 3) = '1' Then GUICtrlSetState($r_fs, 1)
		If FileReadLine($s_pix & 'P!xShot.cfg', 3) = '2' Then GUICtrlSetState($r_ti, 1)
		If FileReadLine($s_pix & 'P!xShot.cfg', 3) = '3' Then GUICtrlSetState($r_nt, 1)
		If FileReadLine($s_pix & 'P!xShot.cfg', 3) = '4' Then GUICtrlSetState($r_ni, 1)

		GUISetState(@SW_SHOW, $GUI)
	ElseIf StringInStr($CmdLine[1], '/del') Then
		_Remove( )
	EndIf
Else
	If Not FileExists($s_pix & 'P!xShot.cfg') Then Exit ShellExecute(@ScriptFullPath, '/config')
	If Not FileExists($s_pix & 'P!xShot.txt') Then FileWrite($s_pix & 'P!xShot.txt', '0')

	$hMutex = DllCall('kernel32.dll', 'hwnd', 'OpenMutex', 'int', 0x1F0001, 'int', False, 'str', 'P!x Shot')
	If $hMutex[0] Then Exit
	DllCall('kernel32.dll', 'hwnd', 'CreateMutex', 'int', 0, 'int', False, 'str', 'P!x Shot')

	_HotKeyAssign(0x2C, '_PixShot', $HK_FLAG_NOREPEAT)
	_HotKeyAssign(BitOR($CK_CONTROL, 0x2C), '_PixShotRegion', $HK_FLAG_NOREPEAT)
	_HotKeyAssign(BitOR($CK_ALT, 0x2C), '_PixShotWindow', $HK_FLAG_NOREPEAT)
;~ 	HotKeySet('{PRINTSCREEN}' , '_PixShot')
;~ 	HotKeySet('^{PRINTSCREEN}', '_PixShotRegion')
;~ 	HotKeySet('!{PRINTSCREEN}', '_PixShotWindow')
EndIf


While Sleep(1000)
	If $iExit_Event = 1 Then Exit
	_ReduceMemory(-1)
WEnd


#Region Config
Func _PixDir( )
	$f_pix = FileSelectFolder('Select folder where you want to save screenshots', "", 7)

	If Not @error Then
		GUICtrlSetData($e_dir, $f_pix)
		GUICtrlSetState($c_ext, 64)
		GUICtrlSetState($b_ok, 64)
	EndIf
EndFunc   ;==>_PixDir

Func _Apply( )
	If (GUICtrlRead($c_ext) = 'None') Then
		MsgBox(48, 'P!x Shot - Warning', 'Please select a picture extension !')
	Else
		FileDelete($s_pix & 'P!xShot.cfg')
		FileWrite($s_pix & 'P!xShot.cfg', $f_pix)
		If @error Then Exit MsgBox(16, 'P!x Shot - error', _
			'Make sure you have correctly installed P!xShot (directory) !')

		$r_co = GUICtrlRead($c_ext)

		If ($r_co = 'BMP') Then
			FileWrite($s_pix & 'P!xShot.cfg', @CRLF & 'BMP')
		ElseIf ($r_co = 'GIF') Then
			FileWrite($s_pix & 'P!xShot.cfg', @CRLF & 'GIF')
		ElseIf ($r_co = 'PNG') Then
			FileWrite($s_pix & 'P!xShot.cfg', @CRLF & 'PNG')
		ElseIf ($r_co = 'TIF') Then
			FileWrite($s_pix & 'P!xShot.cfg', @CRLF & 'TIF')
		EndIf

		If GUICtrlRead($c_sc) = 1 Then
			FileWrite($s_pix & 'P!xShot.cfg', @CRLF & 'True')
		Else
			FileWrite($s_pix & 'P!xShot.cfg', @CRLF & 'False')
		EndIf

		If GUICtrlRead($r_fs) = 1 Then
			FileWrite($s_pix & 'P!xShot.cfg', @CRLF & '1')
		ElseIf GUICtrlRead($r_ti) = 1 Then
			FileWrite($s_pix & 'P!xShot.cfg', @CRLF & '2')
		ElseIf GUICtrlRead($r_nt) = 1 Then
			FileWrite($s_pix & 'P!xShot.cfg', @CRLF & '3')
		ElseIf GUICtrlRead($r_ni) = 1 Then
			FileWrite($s_pix & 'P!xShot.cfg', @CRLF & '4')
		EndIf

		If GUICtrlRead($c_fs) = 1 Then
			FileWrite($s_pix & 'P!xShot.cfg', @CRLF & 'True')
		Else
			FileWrite($s_pix & 'P!xShot.cfg', @CRLF & 'False')
		EndIf

		$r_jq = GUICtrlRead($e_jq)
		If ($r_co = 'JPG') Then
			FileWrite($s_pix & 'P!xShot.cfg', @CRLF & 'JPG')

			If ($r_jq >= 1) And ($r_jq <= 100) Then
				FileWrite($s_pix & 'P!xShot.cfg', @CRLF & $r_jq)
			Else
				FileWrite($s_pix & 'P!xShot.cfg', @CRLF & '80')
			EndIf
		EndIf

		If GUICtrlRead($c_rst) = 1 Then
			FileDelete($s_pix & 'P!xShot.txt')
			FileWrite($s_pix & 'P!xShot.txt', '0')
		EndIf

		GUISetState(@SW_HIDE, $GUI)
		MsgBox(64, 'P!x Shot', 'Configuration saved !')

		$hMutex = DllCall('kernel32.dll', 'hwnd', 'OpenMutex', 'int', 0x1F0001, 'int', False, 'str', 'P!x Shot')
		If $hMutex[0] Then Exit
		Exit MsgBox(48, 'P!x Shot', 'Please restart P!x Shot !')
	EndIf
EndFunc
#EndRegion Config
;

Func _Exit( )
    GUICtrlSetImage($p_cl, $s_pix & 'close-p.bmp')

    While _IsPressed('01')
        Sleep(10)
    WEnd

    Local $aCur_Info = GUIGetCursorInfo($GUI)
    If (UBound($aCur_Info) > 4 And $aCur_Info[4] = $p_cl) Or _IsPressed('1B') Then
		GUISetState(@SW_HIDE)
		$iExit_Event = 1
    EndIf
EndFunc

Func _PixShot( )
	Local $p_nb = FileRead($s_pix & 'P!xShot.txt')
	Local $p_ext = "." & FileReadLine($s_pix & 'P!xShot.cfg', 5)
	Local $s_cur = FileReadLine($s_pix & 'P!xShot.cfg', 2)

	If FileReadLine($s_pix & 'P!xShot.cfg', 3) = 1 Then
		Local $f_pic = _ScreenCapture_Capture("", -1, -1, -1, -1, $s_cur)
		If FileReadLine($s_pix & 'P!xShot.cfg', 5) = 'JPG' Then _ScreenCapture_SetJPGQuality(FileReadLine($s_pix & 'P!xShot.cfg', 6))
		_ScreenCapture_SaveImage(FileReadLine($s_pix & 'P!xShot.cfg', 1) & '\Pix' & $p_nb +1 & $p_ext, $f_pic)
	ElseIf FileReadLine($s_pix & 'P!xShot.cfg', 3) = 2 Then
		WinSetState('[CLASS:Shell_TrayWnd]', "", @SW_HIDE)
		WinSetState('Program Manager', "", @SW_HIDE)
		Local $f_pic = _ScreenCapture_Capture("", -1, -1, -1, -1, $s_cur)
		If FileReadLine($s_pix & 'P!xShot.cfg', 5) = 'JPG' Then _ScreenCapture_SetJPGQuality(FileReadLine($s_pix & 'P!xShot.cfg', 6))
		_ScreenCapture_SaveImage(FileReadLine($s_pix & 'P!xShot.cfg', 1) & '\Pix' & $p_nb +1 & $p_ext, $f_pic)
		WinSetState('[CLASS:Shell_TrayWnd]', "", @SW_SHOW)
		WinSetState('Program Manager', "", @SW_SHOW)
	ElseIf FileReadLine($s_pix & 'P!xShot.cfg', 3) = 3 Then
		WinSetState('[CLASS:Shell_TrayWnd]', "", @SW_HIDE)
		Local $f_pic = _ScreenCapture_Capture("", -1, -1, -1, -1, $s_cur)
		If FileReadLine($s_pix & 'P!xShot.cfg', 5) = 'JPG' Then _ScreenCapture_SetJPGQuality(FileReadLine($s_pix & 'P!xShot.cfg', 6))
		_ScreenCapture_SaveImage(FileReadLine($s_pix & 'P!xShot.cfg', 1) & '\Pix' & $p_nb +1 & $p_ext, $f_pic)
		WinSetState('[CLASS:Shell_TrayWnd]', "", @SW_SHOW)
	ElseIf FileReadLine($s_pix & 'P!xShot.cfg', 3) = 4 Then
		WinSetState('Program Manager', "", @SW_HIDE)
		Local $f_pic = _ScreenCapture_Capture("", -1, -1, -1, -1, $s_cur)
		If FileReadLine($s_pix & 'P!xShot.cfg', 5) = 'JPG' Then _ScreenCapture_SetJPGQuality(FileReadLine($s_pix & 'P!xShot.cfg', 6))
		_ScreenCapture_SaveImage(FileReadLine($s_pix & 'P!xShot.cfg', 1) & '\Pix' & $p_nb +1 & $p_ext, $f_pic)
		WinSetState('Program Manager', "", @SW_SHOW)
	EndIf

	FileDelete($s_pix & 'P!xShot.txt')
	FileWrite($s_pix & 'P!xShot.txt', $p_nb +1)

	If FileReadLine($s_pix & 'P!xShot.cfg', 4) = 'True' Then _PixFlash($p_nb +1, $p_ext, 1)
EndFunc   ;==>_PixShot

Func _PixShotRegion( )
	Local $s_left = "", $s_top = "", $s_width = "", $s_height = ""

	$hCopyNormal = _CopyImage($hNormal)
	$hCopyIBeam = _CopyImage($hIBeam)
	Local $hPointCursor = _CreateCursorFromResource($hCursor, $dwSize)
	_SetSystemCursor($hPointCursor, $OCR_IBEAM)
	$hPointCursor = _CreateCursorFromResource($hCursor, $dwSize)
	_SetSystemCursor($hPointCursor, $OCR_NORMAL)

	While Not _IsPressed(01)
		$mgp = MouseGetPos( )
		Sleep(50)
	WEnd

	WinMove($GUI_2, "", $mgp[0], $mgp[1], 1, 1)
	GUISetState(@SW_SHOW, $GUI_2)

	While _IsPressed(01) AND Sleep(100)
        $mgp_2 = MouseGetPos( )

        If $mgp_2[0] > $mgp[0] And $mgp_2[1] > $mgp[1] Then
			Local $s_left = $mgp[0], $s_top = $mgp[1], $s_width = $mgp_2[0] - $mgp[0], $s_height = $mgp_2[1] - $mgp[1]
        ElseIf $mgp_2[0] > $mgp[0] And $mgp_2[1] < $mgp[1] Then
			Local $s_left = $mgp[0], $s_top = $mgp_2[1], $s_width = $mgp_2[0] - $mgp[0], $s_height = $mgp[1] - $mgp_2[1]
		ElseIf $mgp_2[0] < $mgp[0] And $mgp_2[1] > $mgp[1] Then
			Local $s_left = $mgp_2[0], $s_top = $mgp[1], $s_width = $mgp[0] - $mgp_2[0], $s_height = $mgp_2[1] - $mgp[1]
		ElseIf $mgp_2[0] < $mgp[0] And $mgp_2[1] < $mgp[1] Then
			Local $s_left = $mgp_2[0], $s_top = $mgp_2[1], $s_width = $mgp[0] - $mgp_2[0], $s_height = $mgp[1] - $mgp_2[1]
		EndIf

		WinMove($GUI_2, "", $s_left, $s_top, $s_width, $s_height)
		ToolTip($s_width & "x" & $s_height)
    WEnd
	ToolTip("")

	GUISetState(@SW_HIDE, $GUI_2)
	_SetSystemCursor($hCopyIBeam, $OCR_IBEAM)
	_SetSystemCursor($hCopyNormal, $OCR_NORMAL)


	If $s_width < 5 And $s_height < 5 Then Return ;Exit Func

	Local $p_nb = FileRead($s_pix & 'P!xShot.txt'), $p_ext = "." & FileReadLine($s_pix & 'P!xShot.cfg', 5)

	Local $f_pic = _ScreenCapture_Capture("", $s_left, $s_top, $s_width, $s_height, FileReadLine($s_pix & 'P!xShot.cfg', 2))
	If FileReadLine($s_pix & 'P!xShot.cfg', 5) = 'JPG' Then _ScreenCapture_SetJPGQuality(FileReadLine($s_pix & 'P!xShot.cfg', 6))
	_ScreenCapture_SaveImage(FileReadLine($s_pix & 'P!xShot.cfg', 1) & '\Pix' & $p_nb +1 & $p_ext, $f_pic)

	FileDelete($s_pix & 'P!xShot.txt')
	FileWrite($s_pix & 'P!xShot.txt', $p_nb +1)

	GLOBAL $s_left = $s_left, $s_top = $s_top, $s_width = $s_width, $s_height = $s_height
	If FileReadLine($s_pix & 'P!xShot.cfg', 4) = 'True' Then _PixFlash($p_nb +1, $p_ext, 2)
EndFunc

Func _PixShotWindow( )
	Local $p_nb = FileRead($s_pix & 'P!xShot.txt')
	Local $p_ext = "." & FileReadLine($s_pix & 'P!xShot.cfg', 5)

	Local $f_pic = _ScreenCapture_CaptureWnd("", WinGetHandle('[active]'), 0, 0, -1, -1, FileReadLine($s_pix & 'P!xShot.cfg', 2))
	If FileReadLine($s_pix & 'P!xShot.cfg', 5) = 'JPG' Then _ScreenCapture_SetJPGQuality(FileReadLine($s_pix & 'P!xShot.cfg', 6))
	_ScreenCapture_SaveImage(FileReadLine($s_pix & 'P!xShot.cfg', 1) & '\Pix' & $p_nb +1 & $p_ext, $f_pic)

	FileDelete($s_pix & 'P!xShot.txt')
	FileWrite($s_pix & 'P!xShot.txt', $p_nb +1)

	If FileReadLine($s_pix & 'P!xShot.cfg', 4) = 'True' Then _PixFlash($p_nb +1, $p_ext, 3)
EndFunc

Func _PixFlash($p_nb, $p_ext, $s_opt)

	SoundPlay($s_pix & 'Capture.wav')
;~ 	GUICtrlSetData($l_pn, 'Pix' & $p_NB & $p_ext)

	If $s_opt = 1 Then ;full screen
		WinSetTrans(_WinAPI_GetDesktopWindow( ), "", 1)
		WinMove($GUI_3, "", 0, 0)
		_SetBitMap($GUI_3, $s_pix & 'win7.png', 215, @DesktopWidth, @DesktopHeight)
	ElseIf $s_opt = 2 Then ;region
		WinMove($GUI_3, "", $s_left, $s_top)
		_SetBitMap($GUI_3, $s_pix & 'win7.png', 215, $s_width, $s_height)
	ElseIf $s_opt = 3 Then ;window
		$f_wgh = WinGetHandle('[active]')
		$f_wgp = WinGetPos($f_wgh)
		WinMove($GUI_3, "", $f_wgp[0], $f_wgp[1])
		_SetBitMap($GUI_3, $s_pix & 'win7.png', 215, $f_wgp[2], $f_wgp[3])
	EndIf

	Sleep(100)
	_SetBitMap($GUI_3, $s_pix & 'win7.png', 0, @DesktopWidth, @DesktopHeight)

	If $s_opt = 1 Then
		WinSetTrans(_WinAPI_GetDesktopWindow( ), "", 255)
	ElseIf $s_opt = 3 Then
		WinSetTrans($f_wgh, "", 255)
	EndIf
EndFunc

Func _Min( )
    GUICtrlSetImage($p_mn, $s_pix & 'min-p.bmp')

    While _IsPressed('01')
        Sleep(10)
    WEnd

    Local $aCur_Info = GUIGetCursorInfo($GUI)
    If UBound($aCur_Info) > 4 And $aCur_Info[4] = $p_mn Then GUISetState(@SW_MINIMIZE)
EndFunc

Func _Move( )
    $f_mgp = MouseGetPos( )
    $f_wgp = WinGetPos($GUI)

    If $f_mgp[1] > $f_wgp[1] + 65 Then Return ;Nothing

    Local $aCur_Info = GUIGetCursorInfo($GUI)
    If UBound($aCur_Info) > 4 And ($aCur_Info[4] = $p_cl Or $aCur_Info[4] = $p_mn) Then Return ;No need to drag by button

    DllCall('user32.dll', 'int', 'SendMessage', 'hWnd', $GUI, 'int', 0x00A1, 'int', 2, 'int', 0)
EndFunc

Func _Remove( )
	WinKill('[Title:' & @SystemDir & '\cmd.exe;CLASS:ConsoleWindowClass]')
	$MsgBox = MsgBox(36, 'P!x Shot - Remove','Are you sure you want to remove P!x shot ?')

	If $MsgBox = 6 Then
		FileDelete($s_pix & 'P!xShot.txt')
		FileDelete($s_pix & 'P!xShot.cfg')

		RegDelete('HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Uninstall\P!x Shot')
		RegDelete('HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Run', 'P!x Shot')
		FileDelete(@DesktopDir & '\P!x Shot - Config.lnk')
		FileDelete($s_pix & 'P!x Shot - Remove.bat')

		MsgBox(64, 'P!x Shot - Remove', 'P!x Shot has been successfuly removed !')
		Exit _SelfDelete( )
	EndIf
EndFunc

Func _Hover($iCtrl)
	Switch $iCtrl
		Case $p_mn
			GUICtrlSetImage($p_mn, $s_pix & 'min-h.bmp')
		Case $p_cl
			GUICtrlSetImage($p_cl, $s_pix & 'close-h.bmp')
	EndSwitch
EndFunc

Func _NoHover($iCtrl)
	Switch $iCtrl
		Case $p_mn
			GUICtrlSetImage($p_mn, $s_pix & 'min-n.bmp')
		Case $p_cl
			GUICtrlSetImage($p_cl, $s_pix & 'close-n.bmp')
	EndSwitch
EndFunc

Func OnAutoItExit( )
	_GDIPlus_Shutdown( )
	_HotKeyDisable( )
EndFunc

#Region Internal
; #FUNCTION# ====================================================================================================================
; Name...........: _IsPressed
; Author ........: ezzetabi and Jon
; ===============================================================================================================================
Func _IsPressed($sHexKey, $vDLL = 'user32.dll')
	Local $a_R = DllCall($vDLL, 'int', 'GetAsyncKeyState', 'int', '0x' & $sHexKey)
	If Not @error And BitAND($a_R[0], 0x8000) = 0x8000 Then Return 1
	Return 0
EndFunc   ;==>_IsPressed

; #FUNCTION# ====================================================================================================================
; Name...........: _ReduceMemory
; Author ........: w_Outer, Rajesh V R, Prog@ndy
; ===============================================================================================================================
Func _ReduceMemory($i_PID = -1)
    If $i_PID = -1 or ProcessExists($i_PID) = 0 Then
        Local $ai_GetCurrentProcess = DllCall('kernel32.dll', 'ptr', 'GetCurrentProcess')
        Local $ai_Return = DllCall("psapi.dll", 'int', 'EmptyWorkingSet', 'ptr', $ai_GetCurrentProcess[0])
        Return $ai_Return[0]
    EndIf

    Local $ai_Handle = DllCall("kernel32.dll", 'ptr', 'OpenProcess', 'int', 0x1f0fff, 'int', False, 'int', $i_PID)
    Local $ai_Return = DllCall("psapi.dll", 'int', 'EmptyWorkingSet', 'ptr', $ai_Handle[0])
    DllCall('kernel32.dll', 'int', 'CloseHandle', 'ptr', $ai_Handle[0])
    Return $ai_Return[0]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: _SelfDelete
; Author ........: Unkown
; ===============================================================================================================================
Func _SelfDelete( )
    Local $sCmdFile, $s_ph = StringLeft(@ScriptFullPath, StringInStr(@ScriptFullPath, '\', 0, -1))

    FileDelete(@TempDir & '\scratch.bat')
    $sCmdFile = 'ping -n 127.0.0.1 > nul' & @CRLF _
            & ':loop' & @CRLF _
			& 'del "' & @ScriptFullPath & '"' & @CRLF _
			& 'rmdir "' & $s_ph & '"' & '"' & @CRLF _
            & 'if exist "' & @ScriptFullPath & '" goto loop' & @CRLF _
            & 'del ' & @TempDir & '\scratch.bat'

    FileWrite(@TempDir & '\scratch.bat', $sCmdFile)
	Run(@TempDir & '\scratch.bat', "", @SW_HIDE)
EndFunc

;===============================================================================
; Function Name: _WinAPI_GetLayeredWindowAttributes
; Author(s): Prog@ndy
;===============================================================================
Func _WinAPI_SetLayeredWindowAttributes($hwnd, $i_transcolor, $Transparency = 255, $dwFlages = 0x03, $isColorRef = False)
	If $dwFlages = Default Or $dwFlages = "" Or $dwFlages < 0 Then $dwFlages = 0x03

	If Not $isColorRef Then
		$i_transcolor = Hex(String($i_transcolor), 6)
		$i_transcolor = Execute('0x00' & StringMid($i_transcolor, 5, 2) & StringMid($i_transcolor, 3, 2) & StringMid($i_transcolor, 1, 2))
	EndIf

	Local $Ret = DllCall("user32.dll", "int", "SetLayeredWindowAttributes", "hwnd", $hwnd, "long", $i_transcolor, "byte", $Transparency, "long", $dwFlages)
	Select
		Case @error
			Return SetError(@error, 0, 0)
		Case $Ret[0] = 0
	;~ 		Return SetError(4, _WinAPI_GetLastError(), 0)
		Case Else
			Return 1
	EndSelect
EndFunc ;==>_WinAPI_SetLayeredWindowAttributes

Func _SetBitmap($h_GUI, $s_img, $iOpacity, $n_width, $n_height)
    $f_img = _GDIPlus_ImageLoadFromFile($s_img)
    $f_gc = _GDIPlus_ImageGetGraphicsContext($f_img)
    $hImage = _GDIPlus_BitmapCreateFromGraphics($n_width, $n_height, $f_gc)
    $f_ngc = _GDIPlus_ImageGetGraphicsContext($hImage)
    _GDIPlus_GraphicsDrawImageRect($f_ngc, $f_img, 0, 0, $n_width, $n_height)

    _GDIPlus_GraphicsDispose($f_gc)
    _GDIPlus_GraphicsDispose($f_ngc)
    _GDIPlus_ImageDispose($f_img)

    $hScrDC = _WinAPI_GetDC(0)
    $hMemDC = _WinAPI_CreateCompatibleDC($hScrDC)
    $hBitmap = _GDIPlus_BitmapCreateHBITMAPFromBitmap($hImage)
    $hOld = _WinAPI_SelectObject($hMemDC, $hBitmap)
    $tSize = DllStructCreate($tagSIZE)
    $pSize = DllStructGetPtr($tSize)
    DllStructSetData($tSize, "X", $n_width)
    DllStructSetData($tSize, "Y", $n_height)
    $tSource = DllStructCreate($tagPOINT)
    $pSource = DllStructGetPtr($tSource)
    $tBlend = DllStructCreate($tagBLENDFUNCTION)
    $pBlend = DllStructGetPtr($tBlend)
    DllStructSetData($tBlend, "Alpha", $iOpacity)
    DllStructSetData($tBlend, "Format", 1)

    _WinAPI_UpdateLayeredWindow($h_GUI, $hScrDC, 0, $pSize, $hMemDC, $pSource, 0, $pBlend, $ULW_ALPHA)
    _WinAPI_ReleaseDC(0, $hScrDC)
    _WinAPI_SelectObject($hMemDC, $hOld)
    _WinAPI_DeleteObject($hBitmap)
    _WinAPI_DeleteDC($hMemDC)
EndFunc
#EndRegion
